/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.IVWTaskButtonPanel;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyChangedListener;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.resources.VWResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class VWTaskApplyButtonPanel
extends JPanel
implements ActionListener,
IVWTaskButtonPanel {
    private VWTaskPropertyChangedListener propertyListener = null;
    private JButton applyButton = null;
    private JButton resetButton = null;
    private JButton helpButton = null;
    private JCheckBox autoStartChk = null;
    private boolean applyEnabled = false;
    private boolean resetEnabled = false;
    private EventListenerList m_actionListenerList = new EventListenerList();
    private static Insets INSETS = new Insets(8, 0, 8, 8);

    public VWTaskApplyButtonPanel(VWTaskPropertyChangedListener listener, boolean autoStartConfigurable, VWTaskBaseNode node) {
        this.propertyListener = listener;
        this.setDoubleBuffered(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (autoStartConfigurable) {
            ++c.gridx;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 21;
            c.insets = new Insets(8, 5, 8, 8);
            this.autoStartChk = new JCheckBox();
            this.autoStartChk.setSelected(node.getAutoStartEnabled());
            this.autoStartChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    VWTaskPropertyChangedEvent propEvent = new VWTaskPropertyChangedEvent((Object)this, VWTaskApplyButtonPanel.this.autoStartChk.getText());
                    VWTaskApplyButtonPanel.this.propertyListener.taskPropertyChanged(propEvent);
                }
            });
            this.updateAutostartText(node);
            this.add((Component)this.autoStartChk, c);
        }
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 22;
        c.insets = INSETS;
        this.applyButton = new JButton(VWResource.Apply);
        this.applyButton.setEnabled(this.applyEnabled);
        this.applyButton.addActionListener(this);
        this.applyButton.setActionCommand(VWTaskActionCommand.APPLY);
        this.add((Component)this.applyButton, c);
        c.weightx = 0.0;
        ++c.gridx;
        c.gridy = 0;
        this.resetButton = new JButton(VWResource.Reset);
        this.resetButton.setEnabled(this.resetEnabled);
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand(VWTaskActionCommand.RESET);
        this.add((Component)this.resetButton, c);
        ++c.gridx;
        c.gridy = 0;
        this.helpButton = new JButton(VWResource.Help);
        this.helpButton.addActionListener(this);
        this.helpButton.setActionCommand(VWTaskActionCommand.HELP);
        this.add((Component)this.helpButton, c);
        VWTaskUtil.updateComponentOrientation(this);
    }

    public void updateAutostartText(VWTaskBaseNode node) {
        if (this.autoStartChk != null) {
            this.autoStartChk.setText(node.getAutomaticallyStartedText());
            this.autoStartChk.setToolTipText(node.getAutomaticallyStartedToolTip());
        }
    }

    public void setDirty() {
        this.applyButton.setEnabled(true);
        this.resetButton.setEnabled(true);
    }

    public void clearDirty() {
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    public boolean isAutoStartSelected() {
        return this.isAutoStartConfigurable() ? this.autoStartChk.isSelected() : false;
    }

    public void setAutoStartSelected(boolean selected) {
        if (this.isAutoStartConfigurable()) {
            this.autoStartChk.setSelected(selected);
        }
    }

    public boolean isAutoStartConfigurable() {
        return this.autoStartChk != null;
    }

    public void addActionListener(ActionListener al) {
        this.m_actionListenerList.add(ActionListener.class, al);
    }

    public void removeActionListener(ActionListener al) {
        this.m_actionListenerList.remove(ActionListener.class, al);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        this.fireActionEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_actionListenerList.getListenerList();
        try {
            VWTaskCore.getInstance().disableApplicationInput();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                ((ActionListener)listeners[i + 1]).actionPerformed(event);
            }
        }
        finally {
            VWTaskCore.getInstance().enableApplicationInput();
        }
    }
}

